<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
     */

    'accepted' => d_trans('The :attribute field must be accepted.'),
    'accepted_if' => d_trans('The :attribute field must be accepted when :other is :value.'),
    'active_url' => d_trans('The :attribute field must be a valid URL.'),
    'after' => d_trans('The :attribute field must be a date after :date.'),
    'after_or_equal' => d_trans('The :attribute field must be a date after or equal to :date.'),
    'alpha' => d_trans('The :attribute field must only contain letters.'),
    'alpha_dash' => d_trans('The :attribute field must only contain letters, numbers, dashes, and underscores.'),
    'alpha_num' => d_trans('The :attribute field must only contain letters and numbers.'),
    'array' => d_trans('The :attribute field must be an array.'),
    'ascii' => d_trans('The :attribute field must only contain single-byte alphanumeric characters and symbols.'),
    'before' => d_trans('The :attribute field must be a date before :date.'),
    'before_or_equal' => d_trans('The :attribute field must be a date before or equal to :date.'),
    'between' => [
        'array' => d_trans('The :attribute field must have between :min and :max items.'),
        'file' => d_trans('The :attribute field must be between :min and :max kilobytes.'),
        'numeric' => d_trans('The :attribute field must be between :min and :max.'),
        'string' => d_trans('The :attribute field must be between :min and :max characters.'),
    ],
    'boolean' => d_trans('The :attribute field must be true or false.'),
    'can' => d_trans('The :attribute field contains an unauthorized value.'),
    'confirmed' => d_trans('The :attribute field confirmation does not match.'),
    'contains' => d_trans('The :attribute field is missing a required value.'),
    'current_password' => d_trans('The password is incorrect.'),
    'date' => d_trans('The :attribute field must be a valid date.'),
    'date_equals' => d_trans('The :attribute field must be a date equal to :date.'),
    'date_format' => d_trans('The :attribute field must match the format :format.'),
    'decimal' => d_trans('The :attribute field must have :decimal decimal places.'),
    'declined' => d_trans('The :attribute field must be declined.'),
    'declined_if' => d_trans('The :attribute field must be declined when :other is :value.'),
    'different' => d_trans('The :attribute field and :other must be different.'),
    'digits' => d_trans('The :attribute field must be :digits digits.'),
    'digits_between' => d_trans('The :attribute field must be between :min and :max digits.'),
    'dimensions' => d_trans('The :attribute field has invalid image dimensions.'),
    'distinct' => d_trans('The :attribute field has a duplicate value.'),
    'doesnt_end_with' => d_trans('The :attribute field must not end with one of the following: :values.'),
    'doesnt_start_with' => d_trans('The :attribute field must not start with one of the following: :values.'),
    'email' => d_trans('The :attribute field must be a valid email address.'),
    'ends_with' => d_trans('The :attribute field must end with one of the following: :values.'),
    'enum' => d_trans('The selected :attribute is invalid.'),
    'exists' => d_trans('The selected :attribute is invalid.'),
    'extensions' => d_trans('The :attribute field must have one of the following extensions: :values.'),
    'file' => d_trans('The :attribute field must be a file.'),
    'filled' => d_trans('The :attribute field must have a value.'),
    'gt' => [
        'array' => d_trans('The :attribute field must have more than :value items.'),
        'file' => d_trans('The :attribute field must be greater than :value kilobytes.'),
        'numeric' => d_trans('The :attribute field must be greater than :value.'),
        'string' => d_trans('The :attribute field must be greater than :value characters.'),
    ],
    'gte' => [
        'array' => d_trans('The :attribute field must have :value items or more.'),
        'file' => d_trans('The :attribute field must be greater than or equal to :value kilobytes.'),
        'numeric' => d_trans('The :attribute field must be greater than or equal to :value.'),
        'string' => d_trans('The :attribute field must be greater than or equal to :value characters.'),
    ],
    'hex_color' => d_trans('The :attribute field must be a valid hexadecimal color.'),
    'image' => d_trans('The :attribute field must be an image.'),
    'in' => d_trans('The selected :attribute is invalid.'),
    'in_array' => d_trans('The :attribute field must exist in :other.'),
    'integer' => d_trans('The :attribute field must be an integer.'),
    'ip' => d_trans('The :attribute field must be a valid IP address.'),
    'ipv4' => d_trans('The :attribute field must be a valid IPv4 address.'),
    'ipv6' => d_trans('The :attribute field must be a valid IPv6 address.'),
    'json' => d_trans('The :attribute field must be a valid JSON string.'),
    'list' => d_trans('The :attribute field must be a list.'),
    'lowercase' => d_trans('The :attribute field must be lowercase.'),
    'lt' => [
        'array' => d_trans('The :attribute field must have less than :value items.'),
        'file' => d_trans('The :attribute field must be less than :value kilobytes.'),
        'numeric' => d_trans('The :attribute field must be less than :value.'),
        'string' => d_trans('The :attribute field must be less than :value characters.'),
    ],
    'lte' => [
        'array' => d_trans('The :attribute field must not have more than :value items.'),
        'file' => d_trans('The :attribute field must be less than or equal to :value kilobytes.'),
        'numeric' => d_trans('The :attribute field must be less than or equal to :value.'),
        'string' => d_trans('The :attribute field must be less than or equal to :value characters.'),
    ],
    'mac_address' => d_trans('The :attribute field must be a valid MAC address.'),
    'max' => [
        'array' => d_trans('The :attribute field must not have more than :max items.'),
        'file' => d_trans('The :attribute field must not be greater than :max kilobytes.'),
        'numeric' => d_trans('The :attribute field must not be greater than :max.'),
        'string' => d_trans('The :attribute field must not be greater than :max characters.'),
    ],
    'max_digits' => d_trans('The :attribute field must not have more than :max digits.'),
    'mimes' => d_trans('The :attribute field must be a file of type: :values.'),
    'mimetypes' => d_trans('The :attribute field must be a file of type: :values.'),
    'min' => [
        'array' => d_trans('The :attribute field must have at least :min items.'),
        'file' => d_trans('The :attribute field must be at least :min kilobytes.'),
        'numeric' => d_trans('The :attribute field must be at least :min.'),
        'string' => d_trans('The :attribute field must be at least :min characters.'),
    ],
    'min_digits' => d_trans('The :attribute field must have at least :min digits.'),
    'missing' => d_trans('The :attribute field must be missing.'),
    'missing_if' => d_trans('The :attribute field must be missing when :other is :value.'),
    'missing_unless' => d_trans('The :attribute field must be missing unless :other is :value.'),
    'missing_with' => d_trans('The :attribute field must be missing when :values is present.'),
    'missing_with_all' => d_trans('The :attribute field must be missing when :values are present.'),
    'multiple_of' => d_trans('The :attribute field must be a multiple of :value.'),
    'not_in' => d_trans('The selected :attribute is invalid.'),
    'not_regex' => d_trans('The :attribute field format is invalid.'),
    'numeric' => d_trans('The :attribute field must be a number.'),
    'password' => [
        'letters' => d_trans('The :attribute field must contain at least one letter.'),
        'mixed' => d_trans('The :attribute field must contain at least one uppercase and one lowercase letter.'),
        'numbers' => d_trans('The :attribute field must contain at least one number.'),
        'symbols' => d_trans('The :attribute field must contain at least one symbol.'),
        'uncompromised' => d_trans('The given :attribute has appeared in a data leak. Please choose a different :attribute.'),
    ],
    'present' => d_trans('The :attribute field must be present.'),
    'present_if' => d_trans('The :attribute field must be present when :other is :value.'),
    'present_unless' => d_trans('The :attribute field must be present unless :other is :value.'),
    'present_with' => d_trans('The :attribute field must be present when :values is present.'),
    'present_with_all' => d_trans('The :attribute field must be present when :values are present.'),
    'prohibited' => d_trans('The :attribute field is prohibited.'),
    'prohibited_if' => d_trans('The :attribute field is prohibited when :other is :value.'),
    'prohibited_unless' => d_trans('The :attribute field is prohibited unless :other is in :values.'),
    'prohibits' => d_trans('The :attribute field prohibits :other from being present.'),
    'regex' => d_trans('The :attribute field format is invalid.'),
    'required' => d_trans('The :attribute field is required.'),
    'required_array_keys' => d_trans('The :attribute field must contain entries for: :values.'),
    'required_if' => d_trans('The :attribute field is required when :other is :value.'),
    'required_if_accepted' => d_trans('The :attribute field is required when :other is accepted.'),
    'required_if_declined' => d_trans('The :attribute field is required when :other is declined.'),
    'required_unless' => d_trans('The :attribute field is required unless :other is in :values.'),
    'required_with' => d_trans('The :attribute field is required when :values is present.'),
    'required_with_all' => d_trans('The :attribute field is required when :values are present.'),
    'required_without' => d_trans('The :attribute field is required when :values is not present.'),
    'required_without_all' => d_trans('The :attribute field is required when none of :values are present.'),
    'same' => d_trans('The :attribute field must match :other.'),
    'size' => [
        'array' => d_trans('The :attribute field must contain :size items.'),
        'file' => d_trans('The :attribute field must be :size kilobytes.'),
        'numeric' => d_trans('The :attribute field must be :size.'),
        'string' => d_trans('The :attribute field must be :size characters.'),
    ],
    'starts_with' => d_trans('The :attribute field must start with one of the following: :values.'),
    'string' => d_trans('The :attribute field must be a string.'),
    'timezone' => d_trans('The :attribute field must be a valid timezone.'),
    'unique' => d_trans('The :attribute has already been taken.'),
    'uploaded' => d_trans('The :attribute failed to upload.'),
    'uppercase' => d_trans('The :attribute field must be uppercase.'),
    'url' => d_trans('The :attribute field must be a valid URL.'),
    'ulid' => d_trans('The :attribute field must be a valid ULID.'),
    'uuid' => d_trans('The :attribute field must be a valid UUID.'),
    'username' => d_trans('The :attribute field must be a valid username.'),
    'block_patterns' => d_trans('The :attribute contains blocked patterns.'),
    'indisposable' => d_trans('The email type are not allowed.'),
    'captcha' => d_trans('Captcha verification failed.'),
    'attributes' => [
        'g-recaptcha-response' => d_trans('captcha'),
        'h-captcha-response' => d_trans('captcha'),
        'cf-turnstile-response' => d_trans('captcha'),
        'terms' => d_trans('terms of service'),
    ],
];